/*------------------------------------------------------------------------------*
 * File Name: PBPlotList.cpp 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * CPY 7/24/2007 WRONG_OBJ_TYPE_CAST_ERR_FROM_VC								*
 * Folger 07/25/07 CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC						*
 * Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND			*
 *	CPY 7/25/2007 QA70-10105 GET_RANGE_STR_NEED_ACCESS_TO_INTERNAL_CONTROL		*
 * Folger 07/26/07 SAVE_COLUMN_HIDDEN_INFO_INTO_REGISTRY						*
 * Folger 07/26/07 REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER						*
 * Folger 07/26/07 ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST					*
 * Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE						*
 * Folger 08/06/07 HIDE_COLUMNS_BY_USER_STORY									*
 * Folger 08/06/07 EXCLUDE_ERRORBAR_THAT_ONLY_Y_COLUMN_SHOWN					*
 * Folger 08/09/07 REARRANGE_COLUMN_BY_CP_SUGGESTION							*
 * Folger 11/07/07 COLUMN_HEADING_LOCALIZE										*
 *	Folger 05/30/08 QA80-11631 EXCLUDE_PLOT_CREATED_BY_TEMP_WKS_IN_RANGE_BROWSER*
 * Kyle 07/15/08 QA80-11840 MOVE_SHOWMENU_TO_BASE_CLASS							*
 * Kyle 07/15/08 QA80-11840 OVER_LOAD_FUNCTION_GETDEFAULTSHOW					*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include "PBListBase.h"

//---- CPY 7/25/2007 QA70-10105 GET_RANGE_STR_NEED_ACCESS_TO_INTERNAL_CONTROL
// I have removed PEPLOT_RANGE for now
//------ Folger 07/26/07 REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER
//------ Folger 07/26/07 ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST
//#define OBJECT_LIST_COL_HEADER		"Layer|Index|Legend|Content|Range"
//------ Folger 08/09/07 REARRANGE_COLUMN_BY_CP_SUGGESTION
//#define OBJECT_LIST_COL_HEADER		"Layer|Index|Size|1st Value|Legend|Content|Range"
//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
//#define OBJECT_LIST_COL_HEADER		_L("Layer|Index|1st Value|Legend|Range|Content|Size")
#ifndef _CAT
#define _CAT "PEPlot"
#endif
#define PLOT_LIST_COL_HEADER		_LC("Layer|Index|1st Value|Legend|Range|Content|Size", _CAT)
//------ End COLUMN_HEADING_LOCALIZE
//------ End REARRANGE_COLUMN_BY_CP_SUGGESTION
//------ End ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST
//#define OBJECT_LIST_COL_HEADER		"Layer|Index|Legend|Data Range"
//------ End REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER
//----	
//------ Folger 08/09/07 REARRANGE_COLUMN_BY_CP_SUGGESTION
//enum{
	//PEPLOT_LAYER,
	//PEPLOT_INDEX,
	////------ Folger 07/26/07 ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST
	//PEPLOT_SIZE,
	//PEPLOT_FIRSTVALUE,
	////------ End ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST
	//PEPLOT_LEGEND,
	//PEPLOT_CONTENT,
	//PEPLOT_RANGE,	//------ Folger 07/26/07 REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER
	//
	//PEPLOT_LAST_ITEM
//};
enum{
	PEPLOT_LAYER,
	PEPLOT_INDEX,
	PEPLOT_FIRSTVALUE,
	PEPLOT_LEGEND,
	PEPLOT_RANGE,
	PEPLOT_CONTENT,
	PEPLOT_SIZE,
	
	PEPLOT_LAST_ITEM
};
//------ End REARRANGE_COLUMN_BY_CP_SUGGESTION
//------Folger 07/25/07 UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
//class PBPlotListMenu : public PBListMenu
//{
//public:
	//PBPlotListMenu(vector<string> vsItems, vector<uint> vnDisplayItems, vector<byte> vbCols) : PBListMenu(vsItems, vnDisplayItems, vbCols)
	//{
	//}
	//virtual bool GetCommand(int& nChoice)
	//{
		//if(m_nChoice >= 0 && m_nChoice <= PEPLOT_RANGE + 2)//MF_SEPARATOR and "Show All"
		//{
			//nChoice = m_nChoice;
			//return true;
		//}
		//return false;
	//}
//};
//------End UNIFY_PBLIST_MENU_BY_ADD_LOWERBOUND_AND_UPPERBOUND
class OC_REGISTERED PBPlotList : public PBListBase
{
public:
	PBPlotList()
	{
		//------ Folger 11/07/07 COLUMN_HEADING_LOCALIZE
		//GetFormatStrAsArray(OBJECT_LIST_COL_HEADER, m_vsColHeadings, "PEObject");
		GetFormatStrAsArray(PLOT_LIST_COL_HEADER, m_vsColHeadings, _CAT);
		//------ End COLUMN_HEADING_LOCALIZE
	}
	~PBPlotList()
	{		
	}
	void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName, int nShowItemType )
	{
		PBListBase::Init(nID, dlg, lpcszDlgName, nShowItemType);
		
		m_PBBType = ITEM_IS_OBJECT;
		
		SetColAlignment(-1, flexAlignLeftCenter);		//------ Folger 08/09/07 REARRANGE_COLUMN_BY_CP_SUGGESTION
	}
	virtual int GetPBListType(){return PB_BROWSER_PLOT_LIST;}
	virtual int GetItemType(int nRow)
	{					
		return ITEM_IS_OBJECT;
	}
	virtual void GetBrowserSupportTypeList(vector<int> &vnList)
	{
		vector<int> vnTypeLit = {EXIST_PLOT};
		vnList = vnTypeLit;
	}
	
	///Kyle 07/15/08 QA80-11840 OVER_LOAD_FUNCTION_GETDEFAULTSHOW
	virtual int	GetDefaultShow( Layer& lay, GridTreeControl* pGridTree, LPCSTR lpcszDefaultShow = NULL )
	{
		int nRow =- 1;
		if( !lay )
			return -1;

		string strDefaultShow( lpcszDefaultShow );
		if( strDefaultShow.IsEmpty() )
		{
			lay.GetRangeString( strDefaultShow );
			strDefaultShow.TrimRight('!');
		}
		else
		{
			string	strBook, strSheet, strCol;
			okutil_parse_complete_range_string(strDefaultShow, strBook, strSheet, strCol);
			okutil_create_complete_range_string_obj(strDefaultShow, strBook, strSheet, NULL);
		}
		nRow = pGridTree->FindRow( strDefaultShow );

		return nRow;
	}
	///End OVER_LOAD_FUNCTION_GETDEFAULTSHOW
	
	///Sophy CLEAN_CODE_PBLIST_CONTROL
	/*
	virtual bool UpdateList(TreeNode trNode, int nShowItemType = 0)
	{
		if(!trNode.IsValid())
			return false;
		
		string strPath;
		trNode.GetAttribute(STR_PATH_ATTRIB, strPath);	
		
		Folder fldr(strPath);		
		if(fldr)
			ClearAll();
		
		string 	strName;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strName);
		Page	pg(strName);
		if(pg)
			ClearAll();
		
		string strPage;
		okutil_get_book_sheet_names(strName, &strPage, &strName); 
		Page pgTemp(strPage);
		Layer lay = pgTemp.Layers(strName);
		if(lay)
			UpdateList(lay);
		
		return false;
	}
	*/
	//virtual
	bool	GetItems( TreeNode& trNode, 
					vector<string>& vsItems, vector<int>& vnPageType, 
					vector<DWORD>& vdwStatus,//vector<bool>& vbHideGray, ///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
					int nShowItemType = 0,
					bool bIncludeShortcut = false)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	{
		if( !trNode.IsValid() )
			return false;
		
		string strName, strPage;
		trNode.GetAttribute( STR_LABEL_ATTRIB, strName );
		okutil_get_book_sheet_names(strName, &strPage, &strName);
		
		Page	pgTemp( strPage );
		Layer	ly = pgTemp.Layers( strName );
		if( ly )
			return GetItems( ly, vsItems, vnPageType, vdwStatus );
		
		return false;
	}
	///end Sophy CLEAN_CODE_PBLIST_CONTROL
	virtual int GetSelectionRangeString(vector<string> &vsSelected)
	{
		GetSelItems(vsSelected);
		return vsSelected.GetSize();
	}
	virtual int GetInitRangeString(vector<string> &vsVals)
	{
		return vsVals.GetSize();
	}
	virtual BOOL SetShowColumns(const vector<uint>& vnShowColumns = NULL)
	{
		vector<byte> vbShowCols;
		vbShowCols.SetSize(PEPLOT_LAST_ITEM);
		vbShowCols = 1;
		//------ Folger 07/26/07 REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER
		//m_vnShowColumns.Data(PEPLOT_LAYER, PEPLOT_CONTENT);
		//------ Folger 08/09/07 REARRANGE_COLUMN_BY_CP_SUGGESTION
		//m_vnShowColumns.Data(PEPLOT_LAYER, PEPLOT_RANGE);
		m_vnShowColumns.Data(PEPLOT_LAYER, PEPLOT_SIZE);
		//------ End REARRANGE_COLUMN_BY_CP_SUGGESTION
		//m_vnShowColumns.RemoveAt(PEPLOT_LEGEND);
		//------ End REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER
		if(vnShowColumns)
			m_vnShowColumns = vnShowColumns;		
		int nSize = m_vnShowColumns.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			int nIndex = m_vnShowColumns[ii];
			if(PEPLOT_LAST_ITEM > nIndex)
				vbShowCols[nIndex] = 0;
		}
		//------ Folger 08/09/07 REARRANGE_COLUMN_BY_CP_SUGGESTION
		//vbShowCols[PEPLOT_LEGEND] = 1;
		//vbShowCols[PEPLOT_RANGE] = 1; //------ Folger 08/06/07 HIDE_COLUMNS_BY_USER_STORY
		vbShowCols[PEPLOT_LAYER] =
		vbShowCols[PEPLOT_INDEX] =
		vbShowCols[PEPLOT_FIRSTVALUE] =
		vbShowCols[PEPLOT_LEGEND] = 1;
		//------ End REARRANGE_COLUMN_BY_CP_SUGGESTION
		//------ Folger 07/26/07 SAVE_COLUMN_HIDDEN_INFO_INTO_REGISTRY
		//SetHiddenCols(vbShowCols);
		LoadHideCols(m_strDlgName, "PBPlotList", &vbShowCols);
		//------ End SAVE_COLUMN_HIDDEN_INFO_INTO_REGISTRY
		return true;
	}
	
protected:	
	virtual string GetRuntimeClass()
	{
		return "PBPlotList";
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual	bool AddItems(PageBase &pb)
	virtual bool AddItems(PageBase &pb, 
						vector<string> &vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus,//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
						const Folder& fldParent = NULL)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		if(!pb)
			return false;
		
		Page page = pb;
		int nLayers = numOfLayers(page);
		
		Page* ppb;
		if(EXIST_PLOT == pb.GetType())
			ppb = new GraphPage(pb);
		else
			return true;
		for(int ii = 0; ii < nLayers; ii++)
		{
			Layer lay = ppb->Layers(ii);
			//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
			//AddItems(lay);
			vector<string> vsSubRows;
			vector<int> vnSubPageType;
			vector<DWORD> vdwSubStatus;
			AddItems(lay, vsSubRows, vnSubPageType, vdwSubStatus);
			vsRows.Append(vsSubRows);
			vnPageType.Append(vnSubPageType);
			vdwStatus.Append(vdwSubStatus);
			//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		}
		delete ppb;
		return true;
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual	bool AddItems(Layer &lay)
	virtual	bool AddItems(Layer &lay, 
						vector<string> &vsRows, vector<int> &vnPageType, 
						vector<DWORD>& vdwStatus)//vector<bool> &vbHideGray)	///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	{
		if (!lay)
			return false;
		
		int nCount;
		//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		Page pg = lay.GetPage();
		bool bHideGray = pg.GetShow() == PAGE_HIDDEN;
		//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
		DWORD dwStatus = bHideGray? PAGE_STATUS_HIDDEN : 0;		///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
		if(EXIST_PLOT == lay.GetPage().GetType())
		{
			GraphLayer gl(lay);
			foreach(DataPlot dp in gl.DataPlots)
			{
				//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
				//AddItems(dp);
				//------Folger 08/06/07 EXCLUDE_ERRORBAR_THAT_ONLY_Y_COLUMN_SHOWN
				if (IS_TXT_ERR_BAR_PLOT_ID(dp.GetPlotType()))
					continue;
				//------End EXCLUDE_ERRORBAR_THAT_ONLY_Y_COLUMN_SHOWN
				
				//------ Folger 05/30/08 QA80-11631 EXCLUDE_PLOT_CREATED_BY_TEMP_WKS_IN_RANGE_BROWSER
				Worksheet wks;
				getColumnByPlot(dp, wks);
				if( wks )
				{
					Page pg = wks.GetPage();
					if ( !pg.IsInManager() )
						continue;
				}
				//------ End EXCLUDE_PLOT_CREATED_BY_TEMP_WKS_IN_RANGE_BROWSER
				
				vsRows.Add(MakeRow(dp));
				vnPageType.Add(-1);		//no need to show icon
				vdwStatus.Add(dwStatus);		///Jasmine 04/27/10 QA81-14826-P5 COMBINE_BOOL_IN_DWORD_TO_SIMPLIFY_FUNC_INTERFACE
				//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
			}
		}
		return true;
	}
	//------ Folger 08/03/07 ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	//virtual bool AddItems(DataObjectBase &dataobj)
	//{
		//string strItem = MakeRow(dataobj);
		//m_flx.AddItem(strItem);
		//ResizeCols();		
		//Layer ly;
		//dataobj.GetParent(ly);
		//Page pg = ly.GetPage();
		//if(pg.GetShow() == PAGE_HIDDEN)
			//SetHideGray(m_flx.Rows-1, 0);
		//return true;
	//}
	//------ End ADD_ALL_ROWS_ONCE_INSTEAD_OF_ONE_BY_ONE
	virtual string MakeCol(OriginObject &obj, int nColType)
	{
		//----- CPY 7/24/2007 WRONG_OBJ_TYPE_CAST_ERR_FROM_VC
		//DataObjectBase dataobj;
		DataPlot dataobj;
		dataobj = obj;
		//-----
		return getDataObjProperties(dataobj, nColType);
	}
	virtual string GetSeletedItemName(int nRow, bool bIncludeFolder = false)
	{
		string strSeletedName;
		if((GetItemType(nRow) != ITEM_IS_OBJECT && !bIncludeFolder) || nRow == 0)
			return "";	
		//---------Folger 07/25/07 CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC
		//strSeletedName = m_flx.Cell(flexcpText, nRow, PEPLOT_LAYER);
		//strSeletedName += "!Plot(" + m_flx.Cell(flexcpText, nRow, PEPLOT_INDEX) + ")";
		//strSeletedName += "\"" + m_flx.Cell(flexcpText, nRow, PEPLOT_LEGEND) + "\"";
		//return strSeletedName;
		//------ Folger 07/26/07 REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER
		//return m_flx.Cell(flexcpText, nRow, PEPLOT_CONTENT);
		return GetCell(flexcpText, nRow, PEPLOT_RANGE);
		//------ End REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER
		//---------End CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC
	}
private:
	UINT numOfLayers(Page &pb)
	{
		if(!pb)
			return -1; //Change 0 to -1 mean not a valid page
		UINT nLayers;
		if(EXIST_GRAPH == pb.GetType())
		{
			GraphPage gp(pb);
			nLayers = gp.Layers.Count();
		}
		else
			nLayers = -1;
		return nLayers;
	}
	//----- CPY 7/24/2007 WRONG_OBJ_TYPE_CAST_ERR_FROM_VC
//	string getDataObjProperties(DataObjectBase &dataobj, int nColType)
	string getDataObjProperties(DataPlot &dp, int nColType)
	//-----
	{
		Layer ly;
		dp.GetParent(ly);
		string strShowName ;
		if(EXIST_PLOT != ly.GetPage().GetType())
			return strShowName;
		//------ Folger 07/26/07 ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST
		//XYRange drXY;
		//dp.GetDataRange(drXY);
		//int r1, r2, c1, c2;
		//Worksheet wks;
		//if (drXY)
			//drXY.GetRange("Y", r1, c1, r2, c2, wks);
		//Column col(wks, c1);
		Worksheet wks;
		Column col;
		int c1 = getColumnByPlot(dp, wks, col);
		//------ End ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST
		switch (nColType)
		{
		case PEPLOT_LAYER:
			ly.GetRangeString(strShowName);
			strShowName.TrimRight('!');
			break;
		case PEPLOT_INDEX:
			strShowName = (string)(dp.GetIndex() + 1);
			break;
		//------ Folger 07/26/07 ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST
		case PEPLOT_SIZE:
			strShowName = ftoa(col.GetUpperBound() - col.GetLowerBound() + 1);
			break;
		case PEPLOT_FIRSTVALUE:
			wks.GetCell(col.GetLowerBound(), c1, strShowName);
			break;
		//------ End ADD_COLUMN_SIZE_AND_FIRSTVALUE_IN_PLOT_LIST
		case PEPLOT_LEGEND:
			dp.GetLegend(strShowName);
			break;
		//---- CPY 7/24/07 RANGE_BROWSER_NEED_BETTER_RANGE_STR
		//---------Folger 07/25/07 CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC
		case PEPLOT_CONTENT:
			///---- CPY YuI 08/06/07 QA70-10107 RANGE_STRING_FROM_RANGE_IS_NEEDED
			//dp.GetRangeString(strShowName, NTYPE_BOOKSHEET_XY_RANGE | NTYPE_ADD_ROW_RANGE);
			dp.GetRangeString(strShowName, NTYPE_BOOKSHEET_XY_RANGE_WITH_DESIGNATIONS | NTYPE_ADD_ROW_RANGE);
			///----
			break;
		//---------End CLEAN_UP_ALL_RANGE_PROCEESING_CODE_IN_OC
		//------ Folger 07/26/07 REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER	CPY 7/25/2007 changed to  NTYPE_BOOKSHEET_XY_RANGE | NTYPE_ADD_ROW_RANGE etc
		case PEPLOT_RANGE:
			dp.GetRangeString(strShowName, NTYPE_FOR_RANGE);
		//------ End REARRANGE_COLOMN_SHOWN_IN_RANGE_BROWSER
		//----
			break;
		default:
			break;
		}		
		return strShowName;
	}
	
	int getColumnByPlot(const DataPlot &dp, Worksheet &wks, Column &col = NULL)
	{
		XYRange drXY;
		dp.GetDataRange(drXY);
		int r1, r2, c1, c2;
		if (drXY)
			drXY.GetRange("Y", r1, c1, r2, c2, wks);
		if ( col )
			col.Attach(wks, c1);
		return c1;
	}
	
};